﻿using System;
using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.PlayerLoop;

public class CarRoadSenser : MonoBehaviour
{
    // Start is called before the first frame update
    void Start()
    {

    }

    bool RayCastWithRoad(Vector3 Point)
    {
        var H = Physics.RaycastAll(Point, Vector3.down);
        for (int i = 0; i < H.Length; i++)
        {
            if (H[i].transform.name == "road_0001")
                return true;
        }
        return false;
        //return Physics.Raycast(Point, Vector3.down, out hit, Mathf.Infinity) && hit.collider.tag != "Road";
    }

    Vector3 IntersectWithRoad(Vector3 Dir, float Dist = 50)
    {
        var P1 = transform.position;
        var P2 = P1 + transform.TransformDirection(Dir).normalized * Dist;
        while (Dist > 0.1)
        {
            var P = (P1 + P2) / 2;
            if (RayCastWithRoad(P))
                P1 = P;
            else
                P2 = P;
            Dist = Dist / 2;
        }
        if (RayCastWithRoad(P1))
            return P2;
        else
            return transform.position;
    }

    Vector3 IntersectWithRoad(float Angle)
    {
        Angle = Angle * (float)Math.PI / 180;
        return IntersectWithRoad(new Vector3((float)Math.Sin(Angle), 0, (float)Math.Cos(Angle)));
    }

    public struct MyInersection
    {
        public Vector3 Point;
        public float Dist;
    }
    public MyInersection[] Intersections(float Angle1, float Angle2, int Count)
    {
        MyInersection[] Result = new MyInersection[Count];
        float Step = (Angle2 - Angle1) / (Count - 1);
        for (int i = 0; i < Count; i++)
        {
            Result[i].Point = IntersectWithRoad(Angle1);
            Result[i].Dist = Vector3.Distance(transform.position, Result[i].Point);
            Angle1 += Step;
        }
        return Result;
    }



    // Update is called once per frame

    void FixedUpdate()
    {
    }
}
